///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool OnAuthSuccess(int Client)
{
    char StatusTemp[255];

    if(!CI[Client].WPCustDB.DBConnect(gsSQLCustDriver, gsSQLCustServer, gsSQLCustUserID, gsSQLCustPassword, CI[Client].CompanyDB))
    {
        sprintf(StatusTemp, "(%d) Error in OnAuthSuccess: Error connecting to customer database.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);
        glErrorCount++;
        return false;
    }

    return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthProcessCommand(int Client, char *ReceivedData, int ReceivedSize)
{
    int FlagLength = 0;
    int FlaggedLength = 0;
    char FlaggedData[MaxReceiveSize + 1];
	char SendTemp[MaxReceiveSize + 1];

    char StatusTemp[255];

	if((FlagLength = CompareFlagedString(ReceivedData, "::Authentication:")))
    {
        sprintf(StatusTemp, "(%d) Auth Command: Authentication.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        if(ReceivedSize - FlagLength > MaxReceiveSize || ReceivedSize - FlagLength < 8)
        {
            SimpleServerSend(Client, "::Error:Fatal error accepting authentication.");
            glErrorCount++;
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        if( strcmp(gsAuthString, FlaggedData) == 0)
        {
            CI[Client].Authenticated = true;
            sprintf(StatusTemp, "(%d) Auth: Authentication Success.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);
            SimpleServerSend(Client, "::ReqCompanyName");
    		return AUTH_CMD_OK;
        }

        sprintf(StatusTemp, "(%d) Auth: Authentication Failed.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        SimpleServerSend(Client, "::Error:Pre-connect authentication failed.");
        glWarningCount++;
        return AUTH_CMD_FAILED;
    }
    else if( strcmp(ReceivedData, "Request.Disconnect") == 0)
    {
        sprintf(StatusTemp, "(%d) Auth Command: Disconnect.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);
        return AUTH_CMD_DISCONNECT;
    }
    else if(CI[Client].Authenticated == false)
    {
        sprintf(StatusTemp, "(%d) Auth Command: Unauthorized command.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);
        return AUTH_CMD_FAILED;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::CompanyName:")))
    {
        sprintf(StatusTemp, "(%d) Auth Command: CompanyName.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        if(ReceivedSize - FlagLength > 64 || ReceivedSize - FlagLength < 1)
        {
            glErrorCount++;
            sprintf(StatusTemp, "(%d) Auth: Fatal error accepting CompanyName.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);

            SimpleServerSend(Client, "::Error:Fatal error accepting CompanyName.");
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        strcpy(CI[Client].CompanyName, FlaggedData);
        SimpleServerSend(Client, "::ReqCompanyPassword");

        sprintf(StatusTemp, "(%d) Auth: Company name: '%s'.", MyServer.ClientID[Client], CI[Client].CompanyName);
        WriteLog(StatusTemp);

        return AUTH_CMD_OK;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::CompanyPassword:")))
    {
        sprintf(StatusTemp, "(%d) Auth Command: CompanyPassword.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        if(ReceivedSize - FlagLength > 64 || ReceivedSize - FlagLength < 1)
        {
            glErrorCount++;
            sprintf(StatusTemp, "(%d) Auth: Fatal error accepting CompanyPassword.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);

            SimpleServerSend(Client, "::Error:Fatal error accepting CompanyPassword.");
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        strcpy(CI[Client].CompanyPassword, FlaggedData);

        sprintf(StatusTemp, "(%d) Auth: Company password: '%s'.", MyServer.ClientID[Client], CI[Client].CompanyPassword);
        WriteLog(StatusTemp);

        if(IsValidCompanyPassword(Client))
        {
            SimpleServerSend(Client, "::ReqClientVersion");
            return AUTH_CMD_OK;
        }

        sprintf(StatusTemp, "(%d) Auth: Invalid company account.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        glWarningCount++;

        SimpleServerSend(Client, "::Error:Invalid company account.");
        return AUTH_CMD_FAILED;
    }
    else if((FlagLength = CompareFlagedString(ReceivedData, "::ClientVersion:")))
    {
        sprintf(StatusTemp, "(%d) Auth Command: ClientVersion.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        if(ReceivedSize - FlagLength > 64 || ReceivedSize - FlagLength < 1)
        {
            sprintf(StatusTemp, "(%d) Auth: Fatal error accepting ClientVersion.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);

            SimpleServerSend(Client, "::Error:Fatal error accepting ClientVersion.");
            glErrorCount++;
            return AUTH_CMD_DISCONNECT;
        }

    	FlaggedLength = GetFlagedValue(ReceivedData, FlagLength, ReceivedSize, FlaggedData);
        FlaggedData[FlaggedLength] = '\0';

        strcpy(CI[Client].ClientVersion, FlaggedData);

        sprintf(StatusTemp, "(%d) Auth: ClientVersion: '%s'.", MyServer.ClientID[Client], CI[Client].ClientVersion);
        WriteLog(StatusTemp);

        char UpdateHTTPURL[1024 + 1];

        int CVResult = IsValidClientVersion(Client, UpdateHTTPURL);
        if(CVResult == CLIENTVER_CURRENT){
            SimpleServerSend(Client, "::Authentication.Success");
            return AUTH_CMD_SUCCESS;
        }
        else if(CVResult == CLIENTVER_SUPPORTED){
            SimpleServerSend(Client, "::Message:Client software is outdated but still supported. Update soon!");
            SimpleServerSend(Client, "::Authentication.Success");
            return AUTH_CMD_SUCCESS;
        }
        else if(CVResult == CLIENTVER_OUTDATED){
            SimpleServerSend(Client, "::Message:Client software is outdated. Update now!");
            return AUTH_CMD_DISCONNECT;
        }
        else if(CVResult == CLIENTVER_AUTOUPDATE){
            sprintf(StatusTemp, "(%d) Auth: Performing client autoupdate.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);

            sprintf(SendTemp, "::AutoUpdate:%s", UpdateHTTPURL);
            SimpleServerSend(Client, SendTemp);
            return AUTH_CMD_DISCONNECT;
        }
        else{
            sprintf(StatusTemp, "(%d) Auth: Error verifing client version.", MyServer.ClientID[Client]);
            WriteLog(StatusTemp);

            SimpleServerSend(Client, "::Error:Error verifing client version. Update now!");
            return AUTH_CMD_DISCONNECT;
        }

        sprintf(StatusTemp, "(%d) Error in AuthProcessCommand :: Logic failed in ClientVersion.", MyServer.ClientID[Client]);
        WriteLog(StatusTemp);

        SimpleServerSend(Client, "::Error:Error verifing client version. Update now!");
        glErrorCount++;
        return AUTH_CMD_FAILED;
    }

    sprintf(StatusTemp, "(%d) Auth: Received unknown command.", MyServer.ClientID[Client]);
    WriteLog(StatusTemp);

    return AUTH_CMD_UNKNOWN;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int AuthenticateClient(int Client)
{
    char ReceiveData[MaxReceiveSize];
    int ReceiveSize = 0;

    while(MyServer.Connected[Client])
    {
        if(MyServer.GetReceiveData(Client, ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            int AuthCmdResult = AuthProcessCommand(Client, ReceiveData, ReceiveSize);

            if(AuthCmdResult == AUTH_CMD_FAILED)
            {
                Sleep(100);
                return AUTH_CMD_FAILED;
            }
            else if(AuthCmdResult == AUTH_CMD_UNKNOWN){
                Sleep(100);
                return AUTH_CMD_UNKNOWN;
            }
            else if(AuthCmdResult == AUTH_CMD_DISCONNECT){
                Sleep(100);
                return AUTH_CMD_DISCONNECT;
            }
            else if(AuthCmdResult == AUTH_CMD_SUCCESS){
                Sleep(100);

                if(OnAuthSuccess(Client))
                {
                    return AUTH_CMD_SUCCESS;
                }
                else return AUTH_CMD_DISCONNECT;
            }
            else if(AuthCmdResult == AUTH_CMD_OK){
                Sleep(100);
                // Still authenticating
            }
        }
        else Sleep(1);

        Sleep(1);
    }

//    WriteLog("AuthCmdResult DISCONNECTED.");
    return AUTH_CMD_DISCONNECT;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

